#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_AntibodyType : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
		}

		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType();

			Assert.AreEqual(int.MinValue, tmpAT.AntibodyTypeId, "AntibodyTypeId");
			Assert.AreEqual(string.Empty, tmpAT.AntibodyTypeName, "AntibodyTypeName");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		public void Ctor_Id_Pass()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType((int)2);

			Assert.AreEqual(2, tmpAT.AntibodyTypeId);
		}

		[Test]
		public void Ctor_Id_Fail()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType(int.MaxValue);

			Assert.AreEqual(int.MinValue, tmpAT.AntibodyTypeId);
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			string tmpValue = System.DateTime.Now.ToString();

			DataTable dt = new DataTable(TABLES.AntibodyType.TableName);
			dt.Columns.Add(TABLES.AntibodyType.AntibodyTypeId, typeof(int));
			dt.Columns.Add(TABLES.AntibodyType.AntibodyTypeName, typeof(string));

			DataRow dr = dt.NewRow();

			dr[TABLES.AntibodyType.AntibodyTypeId] = 1;
			dr[TABLES.AntibodyType.AntibodyTypeName] = tmpValue;

			BOL.AntibodyType tmpAT = new BOL.AntibodyType(dr);

			Assert.AreEqual(1, tmpAT.AntibodyTypeId, "AntibodyTypeId");
			Assert.AreEqual(tmpValue, tmpAT.AntibodyTypeName, "AntibodyTypeName");
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void AntibodyTypeId_Pass()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType((int)2);

			Assert.AreEqual(2, tmpAT.AntibodyTypeId);
		}

		[Test]
		public void AntibodyTypeId_Fail()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType(int.MaxValue);

			Assert.AreEqual(int.MinValue, tmpAT.AntibodyTypeId);
		}

		[Test]
		public void AntibodyTypeName_Pass()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType((int)2);

			Assert.AreEqual("Anti-A1", tmpAT.AntibodyTypeName);
		}

		[Test]
		public void AntibodyTypeName_Fail()
		{
			BOL.AntibodyType tmpAT = new BOL.AntibodyType(int.MaxValue);

			Assert.AreEqual(string.Empty, tmpAT.AntibodyTypeName);
		}

		[Test]
		public void GetAntibodyTypeLookupList_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntibodyTypeLookupList();

			Assert.IsNotNull(dtTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyTypeLookupList_Fail()
		{
		}

		[Test]
		public void GetCompleteAntibodyTypeList_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetCompleteAntibodyTypeList();

			Assert.IsNotNull(dtTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCompleteAntibodyTypeList_Fail()
		{
		}

		[Test]
		public void GetAntibodiesWithoutAntigens_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntibodiesWithoutAntigens();

			Assert.IsNotNull(dtTest);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodiesWithoutAntigens_Fail()
		{
		}

		[Test]
		public void GetAntibodyType_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntibodyType();

			Assert.IsNotNull(dtTest);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntibodyType_Fail()
		{
		}

		[Test]
		public void GetBloodUnitsWithAntibodyType_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetBloodUnitsWithAntibodyType(1);

			Assert.IsNotNull(dtTest);
		}

		[Test]
		public void GetBloodUnitsWithAntibodyType_Fail()
		{
			DataTable dtTest = BOL.AntibodyType.GetBloodUnitsWithAntibodyType(4209);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void SaveAntibodyTypes_Pass()
		{
			DataTable dtTest = AntibodyType.GetAntibodyTypeLookupList();

			if (dtTest.Rows.Count == 0) Assert.IsTrue(false, "No AntibodyType data");

			dtTest.AcceptChanges();
			dtTest.Rows[0][TABLES.AntibodyParameter.CompatibilityPercentage] = new Random().Next(1,49);

			bool retValue = AntibodyType.SaveAntibodyTypes(dtTest, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(true, retValue);
		}

		[Test]
		public void SaveAntibodyTypes_Fail()
		{
			DataTable dtTest = AntibodyType.GetAntibodyTypeLookupList();

			if (dtTest.Rows.Count == 0) Assert.IsTrue(false, "No AntibodyType data");

			dtTest.AcceptChanges();

			bool retValue = AntibodyType.SaveAntibodyTypes(dtTest, Common.UpdateFunction.UnitTests);

			Assert.AreEqual(false, retValue);
		}

		[Test]
		public void GetAntigenTest_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntigenTest();

			Assert.IsNotNull(dtTest);
		}		

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTest_Fail()
		{
		}	

		[Test]
		public void GetAntibodiesForAntigenType_Pass()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntibodiesForAntigenType(1);

			Assert.IsNotNull(dtTest);
		}		

		[Test]
		public void GetAntibodiesForAntigenType_Fail()
		{
			DataTable dtTest = BOL.AntibodyType.GetAntibodiesForAntigenType(4209);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}	

	}
}

#endif
